/**
*    PushButton.cpp
*    
*    Class to control input from a pushbutton switch.
*    
*    Program written by Lopuz3
*    Spring 2013 
**/

#include "Arduino.h"
#include "PushButton.h"

PushButton::PushButton(int pin)
{
  pinMode(pin, INPUT);
  _pin = pin;
  lastState = false;
}

PushButton::PushButton()
{
	//creates a blank object for arrays
}

boolean PushButton::wasPressed()
{
	return !lastState && isDown();
}

boolean PushButton::isDown()
{
  return (digitalRead(_pin) == HIGH);
}

boolean PushButton::wasReleased()
{
  boolean newState = isDown();
  boolean returnVal = lastState && !newState;
  lastState = newState;
  return returnVal;
}